#ifndef SGRESEAU_H
#define SGRESEAU_H

#include <stdlib.h>
#include <stdio.h>
#include <winsock2.h>
#include <mem.h>
#include "liste.h"

#define g_SGReseau SGReseau::getSGReseau()

struct CellEvent
{
    char cNumJoueur;
    char cNumEvent;
};

struct CellJoueur
{
    char cNumJoueur;
    char *szNomJoueur;
};

class SGReseau
{
    private :
        // liste d'vnements reus du reseau
        ListeChainee<CellEvent> * m_pListeEvents;
        // liste d'vnements a envoyer sur le reseau
        ListeChainee<CellEvent> * m_pListeRxEvents;
        char m_cNumJoueur;
        SOCKET m_Sock;
        SOCKADDR_IN m_Sin;
        FILE * fich;
        static SGReseau * s_pSGReseau;
        int m_iNbJoueurs;
        ListeChainee<CellJoueur> * m_pListeJoueurs;
    
    public :
        // Constructeur par dfaut
        SGReseau();
        // Destructeur
        ~SGReseau();
     
        static SGReseau & getSGReseau() { return *s_pSGReseau; }
        
        // Envoi la liste des vnements et attend de recevoir
        // liste d'vnements des autres joueurs
        void updateReseau();
        // Connecte la machine au seveur et assigne au joueur
        // son numro
        // szNomJoueur est le nom du joueur sur la partie
        void connectServ(char * szHostName, char * szNomJoueur);
        //retourne le numero du joueur
        int getNumJoueur();
        // Dconnecte la machine du serveur
        void disconnect();
        // Ajoute un vnement  la liste d'vnements a envoyer sur le reseau
        void addRxEvent(char cNumJoueur, char cNumEvent);
        // Ajoute un vnement  la liste d'vnements reu du reseau
        void addEvent(char cNumJoueur, char cNumEvent);
        // Retourne VRAI si l'vnement cNumEvent s'est produit
        // Retourne FAUX sinon
        bool testEvent(char cNumJoueur, char cNumEvent);
        // informe le serveur que le joueur est pret
        void ready();
        // Renvoie le nombre de joueurs de la partie
        int getNbJoueurs();
        // Renvoie le nom d'un joueur
        char * getNomJoueur(int iNumJoueur);
};

#endif
